/*

	Copyright (c) 2004 PXI Project Team

	Permission is hereby granted, free of charge, to any person obtaining a copy of
	this software and associated documentation files (the "Software"), to deal in the
	Software without restriction, including without limitation the rights to use,
	copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
	Software, and to permit persons to whom the Software is furnished to do so,
	subject to the following conditions:

	The above copyright notice and this permission notice shall be included in all copies
	or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
	INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
	PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
	HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
	OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
	SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

/*
 
	CLASS bchasm
 
	This is our primary assembler/interpreter class. Basically, you create one, tell it to
	assemble some piece of code (i.e. a string), and then call its interpret() method when
	you're ready to rumble.
 
	GENERAL USAGE
	You start by instantiating an object of type bchasm, and then call its 'assemble' method,
	passing it a string containing a valid CHASM2 program. (Note that you *can* instantiate
	a bchasm object with a string, and it will automatically assemble it for you.) You can
	do whatever you want with the object, until you're ready to run it. Just call its
	interpret() method, and grab whatever it returns (string.)
 
	bchasm is self cleaning.
 
*/

#ifndef _____BCHASM_____
#define _____BCHASM_____

#include <string>
#include <stack>
#include <map>
#include <vector>
#include <ctime> // For ticks and seconds
#include "variant.h"
#include "binarystream.h"
#include "quotesrecord.h"
#include "PXIAbstractFramework.h"

using namespace std;

class bchasm
{
public:
												bchasm							( void );
												bchasm							( const string & );
												~bchasm							( void );
												
			bchasm&								operator=						( const bchasm & );

			string								interpret						( int ip_start = 0 );
			string								interpret_with_prams			( const stack< variant > & );
			string								interpret_from_file				( const string& );
			
			bool								has_handler						( const string & );
			bool								has_function					( const string & );
			
			variant								call_handler					( const string &, const stack< variant > & );
			variant								call_function					( const string &, const stack< variant > & );

			void								assemble						( const string& );
			void								assemble_to_file				( const string&, const string& );
			void								show_listing					( void );

const		string &							get_source						( void );
			int*								get_bytecode					( void );

			int									strcmpi							( const char*, const char* );
			int									stricmp							( const char*, const char* );
			int									bchasm_handle_softinterrupt		( int, int );
			string								standard_out;

			
			void								echomap							( void )
			{
				map< string, int >::iterator i;
				i = var_lookup_indices.begin();
				while( i != var_lookup_indices.end() )
				{
					cout << (*i).second << ": " << (*i).first << endl;
					++i;
				}
				return;
			}

			void								echojumps						( void )
			{
				map< string, int >::iterator i;
				i = label_lookup_indices.begin();
				while( i != label_lookup_indices.end() )
				{
					cout << (*i).second << ": " << (*i).first << ": " << label_lookup_table[ (*i).second ] << endl;
					++i;
				}
				return;
			}
			
private:

			int									fetch_identifier_index			( const string& );
			int									instr_lookup					( const string& );

			void								merge_values					( variant&, variant&, int, variant& );
			string								bool_to_str						( bool );
			bool								str_to_bool						( const string& );
			void								initialize						( void );

			int									min								( int, int );
			int									max								( int, int );

			vector < stack < variant > >		stack_lookup_table;
			vector < variant >					var_lookup_table;
			vector < int >						label_lookup_table;

			map < string, int >					stack_lookup_indices;
			map < string, int >					var_lookup_indices;
			map < string, int >					label_lookup_indices;

			int									bytecode_length; // CRITICAL!!!!!!!!!!!!!
			int									**bytecode;

			string								source;
			
			string								cur_proc;
						
			int ip_start;
			
};

inline int bchasm::min( int x, int y )
{
    return ( x > y ) ? y : x;
}

inline int bchasm::max( int x, int y )
{
    return ( x > y ) ? x : y;
}

#endif
